USE `aoe_db`;
CREATE TABLE `unlocked_achievements` (
    `id` char(26) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ロック解除アチーブメントID',
    `trainee_id` char(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '研修生ID',
    `achievement_id` int unsigned NOT NULL COMMENT 'アチーブメントID',
    `ap_redeemed_at` datetime DEFAULT NULL COMMENT 'AP還元日時',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `unlocked_achievements_trainee_id_achievement_id_unique` (`trainee_id`, `achievement_id`),
    KEY `unlocked_achievements_achievement_id_foreign` (`achievement_id`),
    CONSTRAINT `unlocked_achievements_achievement_id_foreign` FOREIGN KEY (`achievement_id`) REFERENCES `achievements` (`id`),
    CONSTRAINT `unlocked_achievements_trainee_id_foreign` FOREIGN KEY (`trainee_id`) REFERENCES `trainees` (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `unlocked_achievements` (
        `id`,
        `trainee_id`,
        `achievement_id`,
        `ap_redeemed_at`,
        `created_at`,
        `updated_at`
    )
VALUES (
        '01hteb1jxjb1sezq2w4120jbay',
        'GN11904001',
        5,
        '2024-04-03 09:00:02',
        '2024-04-02 11:43:35',
        '2024-04-03 09:00:02'
    ),
    (
        '01hteb3newpwabkxyqz5c47b2b',
        'GN11904005',
        5,
        '2024-04-03 09:00:02',
        '2024-04-02 11:44:44',
        '2024-04-03 09:00:02'
    ),
    (
        '01hteb54aex0wee951j898sgm6',
        'GN11904012',
        5,
        '2024-04-03 09:00:02',
        '2024-04-02 11:45:32',
        '2024-04-03 09:00:02'
    ),
    (
        '01hteb6v76pwn4mcc3hyt7d2zp',
        'SA11904003',
        5,
        '2024-04-03 09:00:02',
        '2024-04-02 11:46:28',
        '2024-04-03 09:00:02'
    ),
    (
        '01hteb86hae5qp787en1r9k2a9',
        'SA11904007',
        5,
        '2024-04-03 09:00:02',
        '2024-04-02 11:47:12',
        '2024-04-03 09:00:02'
    ),
    (
        '01hteba0r6feamq8cd9x1hwfrx',
        'UN11904002',
        5,
        '2024-04-03 09:00:02',
        '2024-04-02 11:48:12',
        '2024-04-03 09:00:02'
    ),
    (
        '01htebbc63xnaf1rbxdkes7nwt',
        'SY11904009',
        5,
        '2024-04-03 09:00:02',
        '2024-04-02 11:48:56',
        '2024-04-03 09:00:02'
    ),
    (
        '01htebecvhaxjf1a7j9z4mryfx',
        'UN11904004',
        5,
        '2024-04-03 09:00:02',
        '2024-04-02 11:50:35',
        '2024-04-03 09:00:02'
    ),
    (
        '01htebfftr9ppfzhmvsfwawf3m',
        'UN11904013',
        5,
        '2024-04-03 09:00:02',
        '2024-04-02 11:51:11',
        '2024-04-03 09:00:02'
    ),
    (
        '01htgwj8fgtmwghwcts2ntd81t',
        'SA11404001',
        2,
        '2024-04-04 09:00:02',
        '2024-04-03 11:28:17',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgwvzctqnvzvbnq5yvgrm02',
        'GN11103001',
        6,
        '2024-04-04 09:00:02',
        '2024-04-03 11:33:35',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgwwe3nghqw3etgmmcj7bct',
        'GN11103001',
        7,
        '2024-04-04 09:00:02',
        '2024-04-03 11:33:50',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgwxt0pc1wptvpryhn5rv3x',
        'GN11103001',
        31,
        '2024-04-04 09:00:02',
        '2024-04-03 11:34:35',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgx0bya81snhmfcmph16exy',
        'SA11308001',
        31,
        '2024-04-04 09:00:02',
        '2024-04-03 11:35:59',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgx0yjdy6k57a8rs7j20y60',
        'SA11308001',
        12,
        '2024-04-04 09:00:02',
        '2024-04-03 11:36:18',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgx3vdqmqhx4jrw679xc884',
        'UN11405001',
        17,
        '2024-04-04 09:00:02',
        '2024-04-03 11:37:53',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgx7mg5f861fek263mqkvra',
        'GN11811002',
        32,
        '2024-04-04 09:00:02',
        '2024-04-03 11:39:57',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgx8b40857j2wbg2bwx3heg',
        'GN11811002',
        17,
        '2024-04-04 09:00:02',
        '2024-04-03 11:40:20',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgxch9r9207vav7p82kxnv3',
        'UN11804002',
        31,
        '2024-04-04 09:00:02',
        '2024-04-03 11:42:38',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgxxnjzsxmgvtax2h8ck26a',
        'GN11103001',
        13,
        '2024-04-04 09:00:02',
        '2024-04-03 11:51:59',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgxyc6ran7bbpagvhswatr8',
        'GN11103001',
        14,
        '2024-04-04 09:00:02',
        '2024-04-03 11:52:22',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgy0268c839h7h5zd64qf5x',
        'SA11308001',
        13,
        '2024-04-04 09:00:02',
        '2024-04-03 11:53:17',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgy19qz6wz3z0anjj37ajtm',
        'SA11308001',
        14,
        '2024-04-04 09:00:02',
        '2024-04-03 11:53:58',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgy44xr0ysqfgpmfp20ge84',
        'UN11804002',
        13,
        '2024-04-04 09:00:02',
        '2024-04-03 11:55:31',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgy4sp31q5p36bz0p47tjh1',
        'UN11804002',
        14,
        '2024-04-04 09:00:02',
        '2024-04-03 11:55:53',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgy7jmnzqh3ebwr8226dqxh',
        'GN11306001',
        13,
        '2024-04-04 09:00:02',
        '2024-04-03 11:57:24',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgy81n2xz8jh2azjkybmmmz',
        'GN11306001',
        14,
        '2024-04-04 09:00:02',
        '2024-04-03 11:57:39',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgybfwt5sxes30nphwrjszh',
        'UN11405001',
        13,
        '2024-04-04 09:00:02',
        '2024-04-03 11:59:32',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgyc05dc46hbc2xs8ej48nc',
        'UN11405001',
        14,
        '2024-04-04 09:00:02',
        '2024-04-03 11:59:49',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgydkwy0r964c3a8kgft617',
        'SA11404001',
        13,
        '2024-04-04 09:00:02',
        '2024-04-03 12:00:42',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgye1ct8ejgtkb9vjfcgyhc',
        'SA11404001',
        14,
        '2024-04-04 09:00:02',
        '2024-04-03 12:00:55',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgymyzxpapxh481dcdef5r9',
        'SY11804001',
        13,
        '2024-04-04 09:00:02',
        '2024-04-03 12:04:42',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgynyfx1v6t0yeste5szeyb',
        'UN11603001',
        13,
        '2024-04-04 09:00:02',
        '2024-04-03 12:05:15',
        '2024-04-04 09:00:02'
    ),
    (
        '01htgyp9fjx2e8zfjka5jj9dn6',
        'UN11603001',
        14,
        '2024-04-04 09:00:02',
        '2024-04-03 12:05:26',
        '2024-04-04 09:00:02'
    ),
    (
        '01hthhyqp173325ttbc5s9g45d',
        'GN11304003',
        17,
        '2024-04-04 09:00:02',
        '2024-04-03 17:42:05',
        '2024-04-04 09:00:02'
    ),
    (
        '01htpm1qdstfyp0wpvh03xft34',
        'SY11904008',
        32,
        '2024-04-06 09:00:02',
        '2024-04-05 16:54:53',
        '2024-04-06 09:00:02'
    ),
    (
        '01htybkswr304ben1dh2ync23k',
        'GN11904001',
        34,
        '2024-04-09 09:00:02',
        '2024-04-08 17:01:23',
        '2024-04-09 09:00:02'
    ),
    (
        '01hv5h4k6q2tcs3kmd5pmdd2ye',
        'SY11904008',
        1,
        '2024-04-12 09:00:02',
        '2024-04-11 11:52:37',
        '2024-04-12 09:00:02'
    ),
    (
        '01hv5h5pds1w6xdp0tt7dee34d',
        'SY11904008',
        4,
        '2024-04-12 09:00:02',
        '2024-04-11 11:53:14',
        '2024-04-12 09:00:02'
    ),
    (
        '01hw4vkfhxwzwwsf1557sg1rap',
        'SA11904003',
        13,
        '2024-04-24 09:00:01',
        '2024-04-23 15:51:58',
        '2024-04-24 09:00:01'
    ),
    (
        '01hw536hrtz8hpa89g2hk4b80j',
        'SA11904003',
        14,
        '2024-04-24 09:00:01',
        '2024-04-23 18:04:43',
        '2024-04-24 09:00:01'
    ),
    (
        '01hw5381j9f7dzh2mpn9z5tsk1',
        'UN11904004',
        13,
        '2024-04-24 09:00:01',
        '2024-04-23 18:05:32',
        '2024-04-24 09:00:01'
    ),
    (
        '01hx8xerr1392pfw8r1mhtexhv',
        'UN11905001',
        35,
        '2024-05-08 09:00:02',
        '2024-05-07 15:57:01',
        '2024-05-08 09:00:02'
    ),
    (
        '01hyj81nj65yb2n0tvkdp28cat',
        'UN11904004',
        14,
        '2024-05-24 09:00:02',
        '2024-05-23 17:10:57',
        '2024-05-24 09:00:02'
    ),
    (
        '01hz1f72vdsmrc5cqb3v48e2df',
        'GN11103001',
        5,
        '2024-05-30 09:00:02',
        '2024-05-29 15:04:51',
        '2024-05-30 09:00:02'
    ),
    (
        '01hznjsr2maj2cq1c5n4zdneyg',
        'UN11904004',
        31,
        '2024-06-07 09:00:02',
        '2024-06-06 10:32:17',
        '2024-06-07 09:00:02'
    ),
    (
        '01j02hmwknr7m6gk1prsawqz2p',
        'SA11504001',
        2,
        '2024-06-12 09:00:02',
        '2024-06-11 11:22:17',
        '2024-06-12 09:00:02'
    ),
    (
        '01j0j9f4wfb58mq6sd894ctj73',
        'GN11904011',
        36,
        '2024-06-18 09:00:02',
        '2024-06-17 14:07:11',
        '2024-06-18 09:00:02'
    ),
    (
        '01j0j9jrpk8zavj5xm4dv9cjwh',
        'GN11904011',
        37,
        '2024-06-18 09:00:02',
        '2024-06-17 14:09:10',
        '2024-06-18 09:00:02'
    ),
    (
        '01j0n64b5gmddqt3b9fpr4y8r6',
        'UN11603001',
        36,
        '2024-06-19 09:00:01',
        '2024-06-18 17:06:35',
        '2024-06-19 09:00:01'
    ),
    (
        '01j0x3s1c6amszdddc8m7t1as5',
        'GN11904001',
        36,
        '2024-06-22 09:00:02',
        '2024-06-21 18:59:23',
        '2024-06-22 09:00:02'
    );
