USE `aoe_db`;
CREATE TABLE `achievements` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'アチーブメントID',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '説明',
  `achievement_type_id` int unsigned NOT NULL COMMENT 'アチーブメント種別ID',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `achievements_achievement_type_id_foreign` (`achievement_type_id`),
  CONSTRAINT `achievements_achievement_type_id_foreign` FOREIGN KEY (`achievement_type_id`) REFERENCES `achievement_types` (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `achievements` (
    `id`,
    `name`,
    `description`,
    `achievement_type_id`,
    `created_at`,
    `updated_at`
  )
VALUES (
    1,
    '時間を守るもの',
    '無遅刻無欠席(ノービス限定)',
    1,
    '2024-03-13 14:00:45',
    '2024-03-13 14:54:38'
  ),
  (
    2,
    '知識の守護者',
    'TEAで初めて満点を取得',
    1,
    '2024-03-13 14:55:40',
    '2024-04-03 11:24:17'
  ),
  (
    3,
    'CTOの右腕',
    '1回のS・T・SでT(助かる)ポイント2ポイント取得',
    2,
    '2024-03-13 14:58:48',
    '2024-03-13 14:59:47'
  ),
  (
    4,
    '眠らずに前進',
    '研修中居眠りしない(ノービス限定)',
    3,
    '2024-03-13 15:00:50',
    '2024-03-13 15:00:50'
  ),
  (
    5,
    'ストリーマーデビュー',
    'PLLにゲストとして初めて出演する',
    1,
    '2024-03-31 19:21:20',
    '2024-03-31 19:21:20'
  ),
  (
    6,
    'THE FIRST',
    'ルーセント・グローバルで最初に進化した者に与えられる称号',
    3,
    '2024-04-02 22:49:56',
    '2024-04-02 22:49:56'
  ),
  (
    7,
    'ファーストリンカー',
    'リンカーに進化した最初の一人',
    1,
    '2024-04-02 22:51:03',
    '2024-04-02 22:51:03'
  ),
  (
    8,
    'ファーストスカラー',
    'スカラーに進化した最初の一人',
    1,
    '2024-04-02 22:51:43',
    '2024-04-02 22:51:43'
  ),
  (
    9,
    'ファーストセージ',
    'セージに進化した最初の一人',
    2,
    '2024-04-02 22:53:53',
    '2024-04-02 22:53:53'
  ),
  (
    10,
    'ファーストエクシード',
    'エクシードに進化した最初の一人',
    2,
    '2024-04-02 22:54:18',
    '2024-04-02 22:54:18'
  ),
  (
    11,
    'ファーストオーバーロード',
    'オーバーロードに進化した最初の一人',
    3,
    '2024-04-02 22:54:45',
    '2024-04-02 22:54:45'
  ),
  (
    12,
    'うたわれるもの',
    '出向先での高い評価がプロフェッサーの耳に届く',
    2,
    '2024-04-02 22:56:32',
    '2024-04-02 22:56:32'
  ),
  (
    13,
    '挑戦者',
    'EX課題に挑戦しレビューを受ける',
    1,
    '2024-04-02 22:58:30',
    '2024-04-02 22:58:30'
  ),
  (
    14,
    '苦難の先へ',
    'EX課題を初めてクリアする',
    1,
    '2024-04-02 22:59:22',
    '2024-04-02 22:59:22'
  ),
  (
    15,
    'ファーストゲートキーパー',
    'ゲートキーパーに進化した最初の一人',
    2,
    '2024-04-02 23:02:57',
    '2024-04-02 23:02:57'
  ),
  (
    16,
    '白羊宮の探究者',
    '白羊宮を非常に高い評価でクリアする',
    1,
    '2024-04-02 23:04:45',
    '2024-04-02 23:04:45'
  ),
  (
    17,
    '金牛宮の探究者',
    '金牛宮を非常に高い評価でクリアする',
    1,
    '2024-04-02 23:06:06',
    '2024-04-02 23:06:06'
  ),
  (
    18,
    '双子宮の探究者',
    '双子宮を非常に高い評価でクリアする',
    1,
    '2024-04-02 23:07:11',
    '2024-04-02 23:07:11'
  ),
  (
    19,
    '巨蟹宮の探究者',
    '巨蟹宮を非常に高い評価でクリアする',
    1,
    '2024-04-02 23:07:44',
    '2024-04-02 23:07:44'
  ),
  (
    20,
    '獅子宮の守り人',
    '獅子宮を非常に高い評価でクリアする',
    1,
    '2024-04-02 23:09:43',
    '2024-04-02 23:09:43'
  ),
  (
    21,
    '処女宮の守り人',
    '処女宮を非常に高い評価でクリアする',
    1,
    '2024-04-02 23:10:27',
    '2024-04-02 23:10:27'
  ),
  (
    22,
    '四星覇王',
    '天秤宮から磨羯宮の全てを非常に高い評価でクリアする',
    3,
    '2024-04-02 23:14:48',
    '2024-04-02 23:14:48'
  ),
  (
    23,
    '双竜迅雷',
    '宝瓶宮と双魚宮を非常に高い評価でクリアする',
    3,
    '2024-04-02 23:21:57',
    '2024-04-02 23:22:18'
  ),
  (
    24,
    'エンジェルの福音',
    'エンジェルを非常に高い評価でクリアする',
    2,
    '2024-04-02 23:26:36',
    '2024-04-02 23:26:36'
  ),
  (
    25,
    'アークエンジェルの福音',
    'アークエンジェルを非常に高い評価でクリアする',
    2,
    '2024-04-02 23:27:00',
    '2024-04-02 23:27:00'
  ),
  (
    26,
    'ヴァーチャーの福音',
    'ヴァーチャーを非常に高い評価でクリアする',
    2,
    '2024-04-02 23:27:33',
    '2024-04-02 23:27:33'
  ),
  (
    27,
    'ドミニオンの福音',
    'ドミニオンを非常に高い評価でクリアする',
    2,
    '2024-04-02 23:27:53',
    '2024-04-02 23:27:53'
  ),
  (
    28,
    'ケルビムの祝福',
    'ケルビムを非常に高い評価でクリアする',
    3,
    '2024-04-02 23:28:11',
    '2024-04-02 23:28:11'
  ),
  (
    29,
    'セラフィムの祝福',
    'セラフィムを非常に高い評価でクリアする',
    3,
    '2024-04-02 23:28:37',
    '2024-04-02 23:28:37'
  ),
  (
    30,
    '祝福の宴',
    '入社式に出席する',
    1,
    '2024-04-02 23:39:24',
    '2024-04-02 23:39:24'
  ),
  (
    31,
    'スピードスター',
    'PG研修開始から1年以内に上位のクラスに進化する',
    3,
    '2024-04-02 23:44:41',
    '2024-04-02 23:44:41'
  ),
  (
    32,
    'クイックトリック',
    'ノービスまたはルーキーから1ヵ月以内に進化する',
    1,
    '2024-04-02 23:47:27',
    '2024-04-02 23:47:27'
  ),
  (
    33,
    'バランスブレイカー',
    '1ヵ月でギルドポイントを5ポイント獲得する',
    2,
    '2024-04-03 00:04:50',
    '2024-04-03 00:04:50'
  ),
  (
    34,
    '問答王者',
    '助手くんの質問に回答してベストアンサーを得る',
    1,
    '2024-04-08 16:43:23',
    '2024-04-08 16:43:23'
  ),
  (
    35,
    '不敗の守護者',
    'セキュリティテストを初見で合格(ノービス限定)',
    2,
    '2024-05-07 15:54:29',
    '2024-05-07 15:54:29'
  ),
  (
    36,
    '匠の握り手',
    '寿司打の高級コースで13000点以上を獲得する',
    1,
    '2024-05-31 17:47:33',
    '2024-05-31 17:47:33'
  ),
  (
    37,
    '閃光の寿司マスター',
    '寿司打の高級コースで18000点以上を獲得する',
    2,
    '2024-05-31 18:16:07',
    '2024-05-31 18:16:07'
  ),
  (
    38,
    'ファーストイージス',
    'イージスに進化した最初の一人',
    3,
    '2024-06-04 15:04:17',
    '2024-06-04 15:04:17'
  );
