USE `lucent_db`;
CREATE TABLE `affiliations` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '所属ID',
    `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `affiliations` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'ビジネス・ソリューション課',
        '2024-03-12 13:41:19',
        '2024-03-12 13:41:19'
    ),
    (
        2,
        '受託開発',
        '2024-03-12 13:41:34',
        '2024-03-12 13:41:34'
    ),
    (
        3,
        'SES事業部(研修生)',
        '2024-03-12 13:41:48',
        '2024-03-12 13:41:48'
    ),
    (
        4,
        'SES事業部',
        '2024-03-12 13:41:53',
        '2024-03-12 13:41:53'
    );
CREATE TABLE `business_card_notations` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '名刺表記ID',
    `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `business_card_notations` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'ゲームプログラマー',
        '2024-03-12 13:19:50',
        '2024-03-12 13:19:50'
    ),
    (
        2,
        'WEBプログラマー',
        '2024-03-12 13:20:00',
        '2024-03-12 13:20:00'
    ),
    (
        3,
        'システムエンジニア',
        '2024-03-12 13:20:09',
        '2024-03-12 13:20:09'
    ),
    (
        4,
        'プログラマー',
        '2024-03-12 13:20:15',
        '2024-03-12 13:20:15'
    ),
    (
        5,
        'インフラオペレーター',
        '2024-03-12 13:20:27',
        '2024-03-12 13:20:27'
    ),
    (
        6,
        'テストエンジニア',
        '2024-03-12 13:20:33',
        '2024-03-12 13:20:33'
    );
CREATE TABLE `departments` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '部署ID',
    `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `departments` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'システム開発部',
        '2024-03-12 13:37:08',
        '2024-03-12 13:37:08'
    ),
    (
        2,
        'コンテンツ開発部',
        '2024-03-12 13:37:14',
        '2024-03-12 13:37:14'
    ),
    (
        3,
        'SES事業部',
        '2024-03-12 13:37:19',
        '2024-03-12 13:37:19'
    );
CREATE TABLE `educations` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '学歴ID',
    `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `educations` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'AA',
        '2024-03-12 14:06:26',
        '2024-03-12 14:06:26'
    ),
    (
        2,
        'BB',
        '2024-03-12 14:06:37',
        '2024-03-12 14:06:37'
    ),
    (
        3,
        'CC',
        '2024-03-12 14:06:44',
        '2024-03-12 14:06:44'
    ),
    (
        4,
        'DD',
        '2024-03-12 14:06:56',
        '2024-03-12 14:06:56'
    ),
    (
        5,
        'EE',
        '2024-03-12 14:07:09',
        '2024-03-12 14:07:09'
    ),
    (
        6,
        'FF',
        '2024-03-12 14:07:13',
        '2024-03-12 14:07:13'
    );
CREATE TABLE `employee_categories` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '社員カテゴリID',
    `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `employee_categories` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'ゲーム',
        '2024-03-12 14:19:28',
        '2024-03-12 14:19:28'
    ),
    (
        2,
        'SE',
        '2024-03-12 14:19:35',
        '2024-03-12 14:19:35'
    ),
    (
        3,
        'PG',
        '2024-03-12 14:19:38',
        '2024-03-12 14:19:38'
    ),
    (
        4,
        'QA',
        '2024-03-12 14:19:42',
        '2024-03-12 14:19:42'
    ),
    (
        5,
        'IF',
        '2024-03-12 14:20:00',
        '2024-03-12 14:20:00'
    ),
    (
        6,
        '新給与',
        '2024-03-12 14:20:06',
        '2024-03-12 14:20:06'
    ),
    (
        7,
        '受託',
        '2024-03-15 08:41:12',
        '2024-03-15 08:41:12'
    );
CREATE TABLE `employee_classes` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '社員分類ID',
    `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `employee_classes` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'SES(ゲーム)',
        '2024-03-12 13:13:35',
        '2024-03-12 13:13:35'
    ),
    (
        2,
        'SES(WEB)',
        '2024-03-12 13:13:41',
        '2024-03-12 13:13:41'
    ),
    (
        3,
        'SES(SE)',
        '2024-03-12 13:13:49',
        '2024-03-12 13:13:49'
    ),
    (
        4,
        'SES(PG)',
        '2024-03-12 13:13:58',
        '2024-03-12 13:13:58'
    ),
    (
        5,
        'SES(オペレーター)',
        '2024-03-12 13:14:08',
        '2024-03-12 13:14:08'
    ),
    (
        6,
        'SES(QA)',
        '2024-03-12 13:14:16',
        '2024-03-12 13:14:16'
    ),
    (
        7,
        'ゲーム研修生',
        '2024-03-12 13:14:27',
        '2024-03-12 13:14:27'
    ),
    (
        8,
        'SE研修生',
        '2024-03-12 13:14:35',
        '2024-03-12 13:14:35'
    ),
    (
        9,
        'PG研修生',
        '2024-03-12 13:14:45',
        '2024-03-12 13:14:45'
    );
CREATE TABLE `employee_management_actions` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '社員対応ID',
    `action` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '対応',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `employee_management_actions` (`id`, `action`, `created_at`, `updated_at`)
VALUES (
        1,
        'AA',
        '2024-03-12 14:25:55',
        '2024-03-12 14:25:55'
    ),
    (
        2,
        'BB',
        '2024-03-12 14:26:02',
        '2024-03-12 14:26:02'
    ),
    (
        3,
        'CC',
        '2024-03-12 14:26:07',
        '2024-03-12 14:26:07'
    ),
    (
        4,
        'DD',
        '2024-03-12 14:26:20',
        '2024-03-12 14:26:20'
    );
CREATE TABLE `employment_types` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '雇用形態ID',
    `name` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `employment_types` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'AA',
        '2024-03-12 12:18:08',
        '2024-03-12 12:18:08'
    ),
    (
        2,
        'BB',
        '2024-03-12 12:18:16',
        '2024-03-12 12:18:16'
    ),
    (
        3,
        'CC',
        '2024-03-12 12:18:33',
        '2024-03-12 12:18:33'
    ),
    (
        4,
        'DD',
        '2024-03-12 12:18:48',
        '2024-03-12 12:18:48'
    ),
    (
        5,
        'EE',
        '2024-03-12 12:18:54',
        '2024-03-12 12:18:54'
    );
CREATE TABLE `enrollment_types` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '在籍区分ID',
    `name` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `enrollment_types` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'AA',
        '2024-03-12 12:12:24',
        '2024-03-12 12:12:24'
    ),
    (
        2,
        'BB',
        '2024-03-12 12:12:32',
        '2024-03-12 12:12:32'
    ),
    (
        3,
        'CC',
        '2024-03-12 12:12:37',
        '2024-03-12 12:12:37'
    );
CREATE TABLE `job_titles` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '職種ID',
    `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `job_titles` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'ゲームPG(UI)',
        '2024-03-12 12:27:13',
        '2024-03-12 12:27:13'
    ),
    (
        2,
        'ゲームPG(Server)',
        '2024-03-12 12:27:27',
        '2024-03-12 12:27:27'
    ),
    (
        3,
        'システムエンジニア',
        '2024-03-12 12:27:38',
        '2024-03-12 12:27:38'
    ),
    (
        4,
        'WEBプログラマー',
        '2024-03-12 12:27:47',
        '2024-03-12 12:27:47'
    ),
    (
        5,
        'プログラマー',
        '2024-03-12 12:27:56',
        '2024-03-12 12:27:56'
    ),
    (
        6,
        'オペレーター',
        '2024-03-12 12:28:05',
        '2024-03-12 12:28:05'
    ),
    (
        7,
        'テスト設計者',
        '2024-03-12 12:28:16',
        '2024-03-12 12:28:16'
    ),
    (
        8,
        'テスター',
        '2024-03-12 12:28:24',
        '2024-03-12 12:28:24'
    );
CREATE TABLE `notifications` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '通知ID',
    `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `notifications` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'AA',
        '2024-03-12 14:01:58',
        '2024-03-12 14:01:58'
    ),
    (
        2,
        'BB',
        '2024-03-12 14:02:09',
        '2024-03-12 14:02:09'
    ),
    (
        3,
        'CC',
        '2024-03-12 14:02:13',
        '2024-03-12 14:02:13'
    );
CREATE TABLE `positions` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '役職ID',
    `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `allowance` int unsigned NOT NULL COMMENT '役職手当',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `positions` (
        `id`,
        `name`,
        `allowance`,
        `created_at`,
        `updated_at`
    )
VALUES (
        1,
        'AA',
        70000,
        '2024-03-12 13:29:50',
        '2024-03-12 13:29:50'
    ),
    (
        2,
        'BB',
        50000,
        '2024-03-12 13:30:05',
        '2024-03-12 13:30:05'
    ),
    (
        3,
        'CC',
        40000,
        '2024-03-12 13:30:22',
        '2024-03-12 13:30:22'
    ),
    (
        4,
        'DD',
        30000,
        '2024-03-12 13:30:37',
        '2024-03-12 13:30:37'
    ),
    (
        5,
        'EE',
        25000,
        '2024-03-12 13:30:51',
        '2024-03-12 13:30:51'
    ),
    (
        6,
        'FF',
        20000,
        '2024-03-12 13:31:11',
        '2024-03-12 13:31:11'
    ),
    (
        7,
        'GG',
        20000,
        '2024-03-12 13:31:52',
        '2024-03-12 13:31:52'
    ),
    (
        8,
        'HH',
        15000,
        '2024-03-12 13:32:03',
        '2024-03-12 13:32:03'
    ),
    (
        9,
        'II',
        0,
        '2024-03-16 20:13:54',
        '2024-03-16 20:13:54'
    );
CREATE TABLE `residential_statuses` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '居住形態ID',
    `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `residential_statuses` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'AA',
        '2024-03-12 14:11:49',
        '2024-03-12 14:11:49'
    ),
    (
        2,
        'BB',
        '2024-03-12 14:11:59',
        '2024-03-12 14:11:59'
    ),
    (
        3,
        'CC',
        '2024-03-12 14:12:07',
        '2024-03-12 14:12:07'
    ),
    (
        4,
        'DD',
        '2024-03-12 14:12:23',
        '2024-03-12 14:12:23'
    ),
    (
        5,
        'EE',
        '2024-03-12 14:12:27',
        '2024-03-12 14:12:27'
    );
CREATE TABLE `salary_types` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '給与形態ID',
    `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `salary_types` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'aa',
        '2024-03-12 13:46:22',
        '2024-03-12 13:46:22'
    ),
    (
        2,
        'bb',
        '2024-03-12 13:46:39',
        '2024-03-12 13:46:39'
    ),
    (
        3,
        'cc',
        '2024-03-12 13:46:45',
        '2024-03-12 13:46:45'
    ),
    (
        4,
        'dd',
        '2024-03-20 23:00:35',
        '2024-03-20 23:00:35'
    );
CREATE TABLE `skills` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'スキルID',
    `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `skills` (`id`, `name`, `created_at`, `updated_at`)
VALUES (
        1,
        'aa',
        '2024-03-12 13:50:42',
        '2024-03-12 13:50:42'
    ),
    (
        2,
        'bb',
        '2024-03-12 13:50:46',
        '2024-03-12 13:50:46'
    ),
    (
        3,
        'cc',
        '2024-03-12 13:50:55',
        '2024-03-12 13:50:55'
    ),
    (
        4,
        'dd',
        '2024-03-12 13:51:06',
        '2024-03-12 13:51:06'
    ),
    (
        5,
        'ee',
        '2024-03-12 13:51:14',
        '2024-03-12 13:51:14'
    ),
    (
        6,
        'ff',
        '2024-03-12 13:51:25',
        '2024-03-12 13:51:25'
    ),
    (
        7,
        'gg',
        '2024-03-12 13:51:41',
        '2024-03-12 13:51:41'
    ),
    (
        8,
        'hh',
        '2024-03-12 13:53:21',
        '2024-03-12 13:53:21'
    ),
    (
        9,
        'ii',
        '2024-03-12 13:51:50',
        '2024-03-12 13:51:50'
    ),
    (
        10,
        'jj',
        '2024-03-12 13:51:58',
        '2024-03-12 13:51:58'
    ),
    (
        11,
        'kk',
        '2024-03-12 13:52:05',
        '2024-03-12 13:52:05'
    ),
    (
        12,
        'll',
        '2024-03-12 13:52:16',
        '2024-03-12 13:52:16'
    ),
    (
        13,
        'mm',
        '2024-03-12 13:52:23',
        '2024-03-12 13:52:23'
    ),
    (
        14,
        'nn',
        '2024-03-12 13:52:34',
        '2024-03-12 13:52:34'
    );
CREATE TABLE `employees` (
    `id` int unsigned NOT NULL COMMENT '社員ID',
    `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '姓',
    `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名',
    `last_name_phonetic` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '姓(ふりがな)',
    `first_name_phonetic` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名(ふりがな)',
    `gender` tinyint unsigned NOT NULL COMMENT '性別(1: 男性, 2: 女性)',
    `birth_date` date NOT NULL COMMENT '生年月日',
    `employment_type_id` int unsigned NOT NULL COMMENT '雇用形態ID',
    `join_date` date NOT NULL COMMENT '入社日',
    `employee_class_id` int unsigned DEFAULT NULL COMMENT '社員分類ID',
    `job_title_id` int unsigned DEFAULT NULL COMMENT '職種ID',
    `position_id` int unsigned NOT NULL COMMENT '役職ID',
    `department_id` int unsigned NOT NULL COMMENT '部署ID',
    `affiliation_id` int unsigned NOT NULL COMMENT '所属ID',
    `business_card_notation_id` int unsigned NOT NULL COMMENT '名刺表記ID',
    `enrollment_type_id` int unsigned NOT NULL COMMENT '在籍区分ID',
    `base_salary` int unsigned NOT NULL COMMENT '基本給',
    `adjustment_allowance` int unsigned DEFAULT NULL COMMENT '調整手当',
    `salary_type_id` int unsigned NOT NULL COMMENT '給与形態ID',
    `transport_expenses` int unsigned DEFAULT NULL COMMENT '交通費',
    `has_bonus_acquisition` tinyint(1) NOT NULL COMMENT '賞与積立有無',
    `main_skill_id` int unsigned NOT NULL COMMENT 'メインスキルID',
    `sub_skill_id` int unsigned DEFAULT NULL COMMENT 'サブスキルID',
    `postal_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '郵便番号',
    `prefecture` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '都道府県',
    `city` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '市区町村',
    `district` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '町域',
    `building_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '建物名等',
    `nearest_station` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '最寄り駅',
    `work_station` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '就業駅',
    `education_id` int unsigned NOT NULL COMMENT '最終学歴ID',
    `has_spouse` tinyint(1) NOT NULL COMMENT '配偶者有無',
    `has_children` tinyint(1) NOT NULL COMMENT '子供有無',
    `emp_cond_notification_id` int unsigned NOT NULL COMMENT '労働条件通知ID',
    `rec_notification_id` int unsigned NOT NULL COMMENT '採用通知ID',
    `join_doc_notification_id` int unsigned NOT NULL COMMENT '入社書類一式通知ID',
    `mobile_number` char(11) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '携帯電話番号',
    `telephone_number` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `email` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `employee_management_action_id` int unsigned DEFAULT NULL COMMENT '社員対応ID',
    `residential_status_id` int unsigned NOT NULL COMMENT '居住形態ID',
    `employee_category_id` int unsigned NOT NULL COMMENT '社員カテゴリID',
    `remarks` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '備考',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `employees_email_unique` (`email`),
    KEY `employees_employment_type_id_foreign` (`employment_type_id`),
    KEY `employees_employee_class_id_foreign` (`employee_class_id`),
    KEY `employees_job_title_id_foreign` (`job_title_id`),
    KEY `employees_position_id_foreign` (`position_id`),
    KEY `employees_department_id_foreign` (`department_id`),
    KEY `employees_affiliation_id_foreign` (`affiliation_id`),
    KEY `employees_business_card_notation_id_foreign` (`business_card_notation_id`),
    KEY `employees_enrollment_type_id_foreign` (`enrollment_type_id`),
    KEY `employees_salary_type_id_foreign` (`salary_type_id`),
    KEY `employees_main_skill_id_foreign` (`main_skill_id`),
    KEY `employees_sub_skill_id_foreign` (`sub_skill_id`),
    KEY `employees_education_id_foreign` (`education_id`),
    KEY `employees_emp_cond_notification_id_foreign` (`emp_cond_notification_id`),
    KEY `employees_rec_notification_id_foreign` (`rec_notification_id`),
    KEY `employees_join_doc_notification_id_foreign` (`join_doc_notification_id`),
    KEY `employees_employee_management_action_id_foreign` (`employee_management_action_id`),
    KEY `employees_residential_status_id_foreign` (`residential_status_id`),
    KEY `employees_employee_category_id_foreign` (`employee_category_id`),
    CONSTRAINT `employees_affiliation_id_foreign` FOREIGN KEY (`affiliation_id`) REFERENCES `affiliations` (`id`),
    CONSTRAINT `employees_business_card_notation_id_foreign` FOREIGN KEY (`business_card_notation_id`) REFERENCES `business_card_notations` (`id`),
    CONSTRAINT `employees_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`),
    CONSTRAINT `employees_education_id_foreign` FOREIGN KEY (`education_id`) REFERENCES `educations` (`id`),
    CONSTRAINT `employees_emp_cond_notification_id_foreign` FOREIGN KEY (`emp_cond_notification_id`) REFERENCES `notifications` (`id`),
    CONSTRAINT `employees_employee_category_id_foreign` FOREIGN KEY (`employee_category_id`) REFERENCES `employee_categories` (`id`),
    CONSTRAINT `employees_employee_class_id_foreign` FOREIGN KEY (`employee_class_id`) REFERENCES `employee_classes` (`id`),
    CONSTRAINT `employees_employee_management_action_id_foreign` FOREIGN KEY (`employee_management_action_id`) REFERENCES `employee_management_actions` (`id`),
    CONSTRAINT `employees_employment_type_id_foreign` FOREIGN KEY (`employment_type_id`) REFERENCES `employment_types` (`id`),
    CONSTRAINT `employees_enrollment_type_id_foreign` FOREIGN KEY (`enrollment_type_id`) REFERENCES `enrollment_types` (`id`),
    CONSTRAINT `employees_job_title_id_foreign` FOREIGN KEY (`job_title_id`) REFERENCES `job_titles` (`id`),
    CONSTRAINT `employees_join_doc_notification_id_foreign` FOREIGN KEY (`join_doc_notification_id`) REFERENCES `notifications` (`id`),
    CONSTRAINT `employees_main_skill_id_foreign` FOREIGN KEY (`main_skill_id`) REFERENCES `skills` (`id`),
    CONSTRAINT `employees_position_id_foreign` FOREIGN KEY (`position_id`) REFERENCES `positions` (`id`),
    CONSTRAINT `employees_rec_notification_id_foreign` FOREIGN KEY (`rec_notification_id`) REFERENCES `notifications` (`id`),
    CONSTRAINT `employees_residential_status_id_foreign` FOREIGN KEY (`residential_status_id`) REFERENCES `residential_statuses` (`id`),
    CONSTRAINT `employees_salary_type_id_foreign` FOREIGN KEY (`salary_type_id`) REFERENCES `salary_types` (`id`),
    CONSTRAINT `employees_sub_skill_id_foreign` FOREIGN KEY (`sub_skill_id`) REFERENCES `skills` (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `employees` (
        `id`,
        `last_name`,
        `first_name`,
        `last_name_phonetic`,
        `first_name_phonetic`,
        `gender`,
        `birth_date`,
        `employment_type_id`,
        `join_date`,
        `employee_class_id`,
        `job_title_id`,
        `position_id`,
        `department_id`,
        `affiliation_id`,
        `business_card_notation_id`,
        `enrollment_type_id`,
        `base_salary`,
        `adjustment_allowance`,
        `salary_type_id`,
        `transport_expenses`,
        `has_bonus_acquisition`,
        `main_skill_id`,
        `sub_skill_id`,
        `postal_code`,
        `prefecture`,
        `city`,
        `district`,
        `building_name`,
        `nearest_station`,
        `work_station`,
        `education_id`,
        `has_spouse`,
        `has_children`,
        `emp_cond_notification_id`,
        `rec_notification_id`,
        `join_doc_notification_id`,
        `mobile_number`,
        `telephone_number`,
        `email`,
        `employee_management_action_id`,
        `residential_status_id`,
        `employee_category_id`,
        `remarks`,
        `created_at`,
        `updated_at`
    )
VALUES (
        11101001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2017-01-10',
        NULL,
        NULL,
        9,
        2,
        2,
        4,
        1,
        0,
        0,
        2,
        0,
        0,
        2,
        6,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        2,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa34@lucent-global.co.jp',
        NULL,
        3,
        7,
        NULL,
        '2024-03-21 22:56:17',
        '2024-03-21 22:56:17'
    ),
    (
        11103001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2016-03-13',
        4,
        5,
        9,
        3,
        4,
        4,
        1,
        0,
        0,
        1,
        0,
        1,
        2,
        3,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        3,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa1@lucent-global.tokyo',
        1,
        3,
        6,
        NULL,
        '2024-03-21 09:42:23',
        '2024-03-21 23:52:09'
    ),
    (
        11209001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2017-09-11',
        NULL,
        NULL,
        9,
        2,
        2,
        4,
        1,
        0,
        0,
        2,
        0,
        0,
        8,
        6,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        3,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa2@lucent-global.co.jp',
        NULL,
        5,
        7,
        NULL,
        '2024-03-21 22:27:13',
        '2024-03-21 23:52:52'
    ),
    (
        11209002,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-03-21',
        NULL,
        NULL,
        8,
        2,
        2,
        4,
        1,
        0,
        0,
        2,
        0,
        0,
        2,
        6,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        5,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa3@lucent-global.co.jp',
        NULL,
        5,
        7,
        NULL,
        '2024-03-21 23:00:57',
        '2024-03-22 09:02:53'
    ),
    (
        11212001,
        'aa',
        'bb',
        'cc',
        'dd',
        2,
        '9999-12-31',
        1,
        '2024-03-21',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        2,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa4@lucent-global.tokyo',
        1,
        5,
        5,
        'ランチOK',
        '2024-03-21 22:32:16',
        '2024-03-21 22:32:16'
    ),
    (
        11304001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2018-04-16',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        3,
        0,
        0,
        12,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        5,
        0,
        0,
        3,
        2,
        3,
        '00000000000',
        '***',
        'a-aa5@lucent-global.tokyo',
        NULL,
        3,
        5,
        NULL,
        '2024-03-21 09:53:36',
        '2024-03-21 23:30:56'
    ),
    (
        11304002,
        'aa',
        'bb',
        'cc',
        'dd',
        2,
        '9999-12-31',
        1,
        '2018-04-01',
        3,
        3,
        9,
        1,
        1,
        3,
        1,
        0,
        0,
        2,
        0,
        0,
        3,
        2,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        2,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa6@lucent-global.tokyo',
        1,
        3,
        2,
        NULL,
        '2024-03-21 22:38:49',
        '2024-03-21 23:48:36'
    ),
    (
        11304003,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2018-04-01',
        3,
        3,
        9,
        1,
        1,
        3,
        1,
        0,
        0,
        2,
        0,
        0,
        3,
        2,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        3,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa7@lucent-global.tokyo',
        2,
        5,
        2,
        NULL,
        '2024-03-21 23:12:12',
        '2024-03-21 23:12:12'
    ),
    (
        11306001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2018-06-18',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        2,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa8@lucent-global.tokyo',
        1,
        5,
        5,
        NULL,
        '2024-03-21 13:58:50',
        '2024-03-21 13:58:50'
    ),
    (
        11308001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2018-08-20',
        4,
        5,
        9,
        3,
        3,
        4,
        1,
        0,
        0,
        1,
        0,
        1,
        8,
        3,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        5,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa9@lucent-global.tokyo',
        1,
        3,
        7,
        NULL,
        '2024-03-21 22:49:56',
        '2024-03-21 22:49:56'
    ),
    (
        11310001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2018-10-02',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        3,
        0,
        0,
        12,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        2,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa10@lucent-global.tokyo',
        1,
        5,
        5,
        NULL,
        '2024-03-21 23:06:14',
        '2024-03-21 23:06:14'
    ),
    (
        11404001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2019-04-01',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        3,
        0,
        0,
        12,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        3,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa11@lucent-global.tokyo',
        1,
        3,
        5,
        NULL,
        '2024-03-21 13:53:32',
        '2024-03-21 13:53:32'
    ),
    (
        11405001,
        'aa',
        'bb',
        'cc',
        'dd',
        2,
        '9999-12-31',
        1,
        '2019-05-13',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        3,
        0,
        0,
        12,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        5,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa12@lucent-global.tokyo',
        1,
        3,
        5,
        NULL,
        '2024-03-21 09:25:27',
        '2024-03-21 09:25:27'
    ),
    (
        11504001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2020-04-01',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        3,
        0,
        0,
        12,
        NULL,
        '1860003',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        2,
        0,
        0,
        2,
        2,
        2,
        '00000000000',
        '***',
        'a-aa13@lucent-global.tokyo',
        1,
        3,
        5,
        NULL,
        '2024-03-21 09:10:24',
        '2024-03-21 23:31:31'
    ),
    (
        11603001,
        'aa',
        'bb',
        'cc',
        'dd',
        2,
        '9999-12-31',
        1,
        '2022-03-16',
        8,
        NULL,
        9,
        2,
        2,
        3,
        1,
        0,
        0,
        2,
        0,
        0,
        3,
        7,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        2,
        0,
        0,
        2,
        3,
        3,
        '00000000000',
        '***',
        'a-aa14@lucent-global.tokyo',
        NULL,
        3,
        7,
        NULL,
        '2024-03-21 22:43:58',
        '2024-03-21 22:43:58'
    ),
    (
        11804001,
        'aa',
        'bb',
        'cc',
        'dd',
        2,
        '9999-12-31',
        1,
        '2024-03-20',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        3,
        0,
        0,
        12,
        13,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        3,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa15@lucent-global.tokyo',
        1,
        5,
        5,
        '基本リモートのため電話かWEB、帰社研修日であればランチ可能',
        '2024-03-20 21:34:59',
        '2024-03-21 23:30:10'
    ),
    (
        11804002,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2023-04-01',
        4,
        5,
        9,
        3,
        4,
        4,
        1,
        0,
        0,
        1,
        0,
        0,
        2,
        3,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        3,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa16@lucent-global.tokyo',
        1,
        3,
        6,
        NULL,
        '2024-03-20 22:30:53',
        '2024-03-20 22:30:53'
    ),
    (
        11804003,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-03-21',
        6,
        8,
        9,
        3,
        4,
        6,
        1,
        0,
        0,
        1,
        0,
        0,
        13,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        3,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa17@lucent-global.tokyo',
        1,
        3,
        6,
        NULL,
        '2024-03-21 14:04:48',
        '2024-03-21 14:04:48'
    ),
    (
        11807001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2023-07-01',
        4,
        5,
        9,
        3,
        4,
        4,
        1,
        0,
        0,
        1,
        0,
        1,
        2,
        NULL,
        '1860003',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        3,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa18@lucent-global.tokyo',
        1,
        3,
        6,
        NULL,
        '2024-03-21 09:15:28',
        '2024-03-21 09:42:40'
    ),
    (
        11811001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-03-21',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        3,
        0,
        0,
        12,
        13,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        2,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa19@lucent-global.tokyo',
        1,
        5,
        5,
        NULL,
        '2024-03-21 08:43:06',
        '2024-03-21 08:43:06'
    ),
    (
        11811002,
        'aa',
        'bb',
        'cc',
        'dd',
        2,
        '9999-12-31',
        1,
        '2023-11-15',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        3,
        0,
        0,
        12,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        5,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa20@lucent-global.tokyo',
        1,
        3,
        5,
        NULL,
        '2024-03-21 09:35:06',
        '2024-03-22 00:00:37'
    ),
    (
        11812001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2023-12-06',
        9,
        8,
        9,
        3,
        3,
        6,
        1,
        0,
        0,
        4,
        0,
        0,
        13,
        14,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        'aa',
        2,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa21@lucent-global.tokyo',
        1,
        3,
        4,
        NULL,
        '2024-03-20 23:00:16',
        '2024-03-22 00:01:15'
    ),
    (
        11904001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        9,
        6,
        9,
        3,
        3,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        13,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        3,
        0,
        0,
        3,
        2,
        3,
        '00000000000',
        '***',
        'a-aa22@lucent-global.tokyo',
        NULL,
        3,
        6,
        NULL,
        '2024-03-20 22:10:00',
        '2024-04-23 13:10:35'
    ),
    (
        11904002,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        9,
        6,
        9,
        3,
        3,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        13,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        3,
        0,
        0,
        3,
        2,
        3,
        '00000000000',
        '***',
        'a-aa23@lucent-global.tokyo',
        1,
        3,
        6,
        NULL,
        '2024-03-20 22:17:49',
        '2024-04-23 13:10:47'
    ),
    (
        11904003,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        9,
        6,
        9,
        3,
        3,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        13,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        3,
        0,
        0,
        2,
        2,
        3,
        '00000000000',
        '***',
        'a-aa24@lucent-global.tokyo',
        1,
        3,
        6,
        NULL,
        '2024-03-20 22:25:13',
        '2024-04-23 13:10:56'
    ),
    (
        11904004,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-03-20',
        9,
        6,
        9,
        3,
        3,
        5,
        1,
        0,
        0,
        1,
        0,
        1,
        12,
        13,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        3,
        0,
        0,
        1,
        1,
        3,
        '00000000000',
        '***',
        'a-aa25@lucent-global.tokyo',
        NULL,
        5,
        6,
        NULL,
        '2024-03-20 22:37:10',
        '2024-04-23 13:11:03'
    ),
    (
        11904005,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        7,
        6,
        9,
        3,
        3,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        13,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        2,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa26@lucent-global.tokyo',
        1,
        3,
        6,
        NULL,
        '2024-03-20 22:42:43',
        '2024-04-23 13:11:19'
    ),
    (
        11904007,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        9,
        6,
        9,
        3,
        3,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        13,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        3,
        0,
        0,
        3,
        2,
        2,
        '00000000000',
        '***',
        'a-aa27@lucent-global.tokyo',
        NULL,
        3,
        6,
        NULL,
        '2024-03-20 22:54:41',
        '2024-04-23 13:11:30'
    ),
    (
        11904008,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        9,
        6,
        9,
        3,
        3,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        2,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa28@lucent-global.tokyo',
        1,
        5,
        5,
        NULL,
        '2024-03-21 08:49:28',
        '2024-04-23 13:11:42'
    ),
    (
        11904009,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        9,
        6,
        9,
        3,
        3,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        13,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        3,
        0,
        0,
        3,
        1,
        3,
        '00000000000',
        '***',
        'a-aa29@lucent-global.tokyo',
        1,
        5,
        6,
        NULL,
        '2024-03-21 08:57:14',
        '2024-04-23 13:12:08'
    ),
    (
        11904011,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        4,
        5,
        9,
        3,
        4,
        4,
        1,
        0,
        0,
        1,
        0,
        0,
        2,
        NULL,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        3,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa30@lucent-global.tokyo',
        1,
        5,
        6,
        NULL,
        '2024-03-21 23:24:58',
        '2024-04-23 13:12:19'
    ),
    (
        11904012,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        6,
        8,
        9,
        3,
        4,
        6,
        1,
        0,
        0,
        1,
        0,
        0,
        13,
        12,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        3,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa31@lucent-global.tokyo',
        1,
        5,
        4,
        NULL,
        '2024-03-28 20:15:30',
        '2024-04-23 13:12:33'
    ),
    (
        11904013,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-04-01',
        6,
        8,
        9,
        3,
        4,
        6,
        1,
        0,
        0,
        1,
        0,
        0,
        13,
        9,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        '宮崎台',
        3,
        0,
        0,
        1,
        1,
        1,
        '00000000000',
        '***',
        'a-aa32@lucent-global.tokyo',
        1,
        2,
        4,
        NULL,
        '2024-03-28 20:20:32',
        '2024-04-23 13:12:51'
    ),
    (
        11905001,
        'aa',
        'bb',
        'cc',
        'dd',
        1,
        '9999-12-31',
        1,
        '2024-05-07',
        9,
        8,
        9,
        3,
        3,
        5,
        2,
        0,
        0,
        1,
        0,
        0,
        13,
        12,
        '0000000',
        '***',
        '***',
        '***',
        '***',
        '***',
        NULL,
        5,
        0,
        0,
        3,
        2,
        2,
        '00000000000',
        '***',
        'a-aa33@lucent-global.tokyo',
        1,
        5,
        4,
        NULL,
        '2024-03-21 23:19:47',
        '2024-05-31 14:15:47'
    ),
    (
        11907001,
        'aa',
        'bb',
        'cc',
        'dd',
        2,
        '2024-06-25',
        1,
        '2024-07-01',
        5,
        6,
        9,
        3,
        4,
        5,
        1,
        0,
        0,
        1,
        0,
        0,
        12,
        NULL,
        '9999999',
        'xxxx',
        'xxxxxxx',
        'xxxxxxx',
        NULL,
        NULL,
        NULL,
        3,
        0,
        0,
        2,
        2,
        1,
        '99999999999',
        NULL,
        'a-aa34@lucent-global.tokyo',
        NULL,
        3,
        5,
        NULL,
        '2024-06-25 11:08:10',
        '2024-06-25 11:12:18'
    );
