USE `aoe_db`;
CREATE TABLE `tea_scores` (
    `id` char(26) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'TEA成績ID',
    `tea_id` int unsigned NOT NULL COMMENT 'TEA ID',
    `trainee_id` char(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '研修生ID',
    `score` int unsigned NOT NULL COMMENT 'スコア',
    `performed_at` datetime NOT NULL COMMENT '実施日時',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `tea_scores_tea_id_foreign` (`tea_id`),
    KEY `tea_scores_trainee_id_foreign` (`trainee_id`),
    CONSTRAINT `tea_scores_tea_id_foreign` FOREIGN KEY (`tea_id`) REFERENCES `teas` (`id`),
    CONSTRAINT `tea_scores_trainee_id_foreign` FOREIGN KEY (`trainee_id`) REFERENCES `trainees` (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `tea_scores` (
        `id`,
        `tea_id`,
        `trainee_id`,
        `score`,
        `performed_at`,
        `created_at`,
        `updated_at`
    )
VALUES (
        '01hsw9srxb96w271g75wmgr887',
        1,
        'SA11807001',
        16,
        '2024-03-26 10:15:00',
        '2024-03-26 11:35:31',
        '2024-03-26 11:35:31'
    ),
    (
        '01hsx2hk2hssgh842vbzpbjdj7',
        1,
        'SA11807001',
        31,
        '2024-03-26 17:35:00',
        '2024-03-26 18:47:57',
        '2024-03-26 18:47:57'
    ),
    (
        '01ht1n11qsqb56y0f7hetb7yqz',
        3,
        'GN11103001',
        44,
        '2024-03-28 10:40:00',
        '2024-03-28 13:27:56',
        '2024-03-28 13:27:56'
    ),
    (
        '01ht1n3cwcv95jz4t776rh4ypv',
        3,
        'SA11308001',
        26,
        '2024-03-28 10:40:00',
        '2024-03-28 13:29:13',
        '2024-03-28 13:29:13'
    ),
    (
        '01htgwh5jvgpascgrq8pfh1360',
        1,
        'SA11404001',
        40,
        '2024-04-03 10:10:00',
        '2024-04-03 11:27:41',
        '2024-04-03 11:27:41'
    ),
    (
        '01htp1nesc4yd0r4w5pgrca5g5',
        1,
        'SA11807001',
        24,
        '2024-04-05 10:10:00',
        '2024-04-05 11:33:36',
        '2024-04-05 11:33:36'
    ),
    (
        '01hvjttfwhh58r95j1b97ymf0c',
        3,
        'SA11308001',
        55,
        '2024-04-15 14:00:00',
        '2024-04-16 15:52:00',
        '2024-04-16 15:52:00'
    ),
    (
        '01hvjvvpqpkk6hefvzyj0829w4',
        3,
        'GN11103001',
        56,
        '2024-04-16 14:00:00',
        '2024-04-16 16:10:08',
        '2024-04-16 16:10:08'
    ),
    (
        '01hvqjmdacwxmn82b2g51qkyh2',
        3,
        'UN11804002',
        40,
        '2024-04-18 10:00:00',
        '2024-04-18 12:05:04',
        '2024-04-18 12:05:04'
    ),
    (
        '01hvr25ypf4mx8v31502tnc1ad',
        3,
        'UN11804002',
        55,
        '2024-04-18 15:00:00',
        '2024-04-18 16:36:48',
        '2024-04-18 16:36:48'
    ),
    (
        '01hyf16cmcjpq14zb4fj4shn1v',
        1,
        'SA11504001',
        22,
        '2024-05-16 10:00:00',
        '2024-05-22 11:13:29',
        '2024-05-22 11:14:01'
    ),
    (
        '01hym7cxr5a31a8dpwr320sma8',
        3,
        'UN11804002',
        59,
        '2024-05-24 10:00:00',
        '2024-05-24 11:38:07',
        '2024-05-24 11:38:07'
    ),
    (
        '01hyw2ey8pk2s5tmm9pgzjswgd',
        1,
        'GN11304003',
        9,
        '2024-05-27 11:30:00',
        '2024-05-27 12:45:45',
        '2024-05-27 12:45:45'
    ),
    (
        '01hz6rsrfv8dtkdgpdebj8367j',
        2,
        'GN11904001',
        58,
        '2024-05-31 14:30:00',
        '2024-05-31 16:28:33',
        '2024-05-31 16:28:33'
    ),
    (
        '01hz6sptd71471hym43xc7aepf',
        2,
        'UN11904004',
        57,
        '2024-05-31 14:30:00',
        '2024-05-31 16:44:25',
        '2024-05-31 16:44:25'
    ),
    (
        '01hz6ta12syhn4vwe9qq9c0zvb',
        2,
        'SA11904003',
        57,
        '2024-05-31 14:30:00',
        '2024-05-31 16:54:54',
        '2024-05-31 16:54:54'
    ),
    (
        '01hz6vggx58mhnszvbxdc7c6hj',
        2,
        'SA11904007',
        48,
        '2024-05-31 14:30:00',
        '2024-05-31 17:15:56',
        '2024-05-31 17:15:56'
    ),
    (
        '01j001ahxej8e1v32z24x0fntf',
        2,
        'GN11306001',
        48,
        '2024-06-10 10:00:00',
        '2024-06-10 11:58:33',
        '2024-06-10 11:58:33'
    ),
    (
        '01j02hmafnb3qhxptk2tvtwrg0',
        1,
        'SA11504001',
        40,
        '2024-06-11 10:00:00',
        '2024-06-11 11:21:59',
        '2024-06-11 11:21:59'
    ),
    (
        '01j054h95wrj033vqwq1w1sdhq',
        3,
        'UN11804002',
        59,
        '2024-06-12 10:00:00',
        '2024-06-12 11:30:51',
        '2024-06-12 11:30:51'
    ),
    (
        '01j0mks859x9q0yhy2ksyjcc1k',
        3,
        'UN11603001',
        26,
        '2024-06-18 10:00:00',
        '2024-06-18 11:45:57',
        '2024-06-18 11:45:57'
    );
