USE `aoe_db`;
CREATE TABLE `teas` (
    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'TEA ID',
    `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
    `passing_score` int unsigned NOT NULL COMMENT '合格ライン',
    `total_questions` int unsigned NOT NULL COMMENT '問題数',
    `question_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '問題URL',
    `answer_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '解答URL',
    `created_at` datetime DEFAULT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `teas` (
        `id`,
        `name`,
        `passing_score`,
        `total_questions`,
        `question_url`,
        `answer_url`,
        `created_at`,
        `updated_at`
    )
VALUES (
        1,
        'Breakfast TEA',
        32,
        40,
        'https://docs.google.com/document/d/1OhQLjxNqPXDigPPEi4jf8FrRnYKqWLNFDeGhvrxrH7Y/edit?usp=sharing',
        'https://docs.google.com/document/d/13peE4sVs0PoCmtWQUE6AYa62OSP9rNVCkx_pBzzS4h8/edit?usp=sharing',
        '2024-03-13 08:45:47',
        '2024-03-13 08:48:49'
    ),
    (
        2,
        'Afternoon TEA',
        54,
        60,
        'https://docs.google.com/document/d/1HtQbDKtm4u9AKQYLk5dsHVH8qG72seavrnR9wmVJf00/edit?usp=sharing',
        'https://docs.google.com/document/d/17RKXnpNsTrCF_rqk1HRf2vshnNbBNKIrPhAARXWd9cc/edit?usp=sharing',
        '2024-03-13 08:47:11',
        '2024-03-13 08:48:49'
    ),
    (
        3,
        'Morning TEA',
        54,
        50,
        'https://docs.google.com/document/d/1uKdOxLbkWgsvDPPssBqzIj2SnGNZ9Ir8BM_zJ9Hh-1s/edit?usp=sharing',
        'https://docs.google.com/document/d/1yrCBolroiE0NaJ2rpgsed6b5azyldrEzoBYbd0Dyj_o/edit?usp=sharing',
        '2024-03-13 08:48:49',
        '2024-03-13 08:48:49'
    );
