/*
 * Decompiled with CFR 0.152.
 */
package com.lucent_global.service;

import com.lucent_global.component.PasswordValidator;
import com.lucent_global.component.RandomStringGenerator;
import com.lucent_global.model.aoe.Trainee;
import com.lucent_global.repository.aoe.TraineeRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
public class TraineeService {
    private static final Logger logger = LoggerFactory.getLogger(TraineeService.class);
    private BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    @Autowired
    private RandomStringGenerator randomStringGenerator;
    @Autowired
    private TraineeRepository traineeRepository;

    public Trainee findById(String id) {
        return (Trainee)this.traineeRepository.findById((Object)id).orElseThrow(() -> new ResponseStatusException(HttpStatus.BAD_REQUEST, "not found trainee by id."));
    }

    public String getIdByMattermostIdAndPassword(String mattermostId, String password) {
        Trainee trainee = (Trainee)this.traineeRepository.findByMattermostId(mattermostId).orElseThrow(() -> new ResponseStatusException(HttpStatus.BAD_REQUEST, "not found trainee by mattermost id."));
        if (!this.passwordEncoder.matches((CharSequence)password, trainee.getPassword())) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "invalid password.");
        }
        return trainee.getId();
    }

    @Transactional
    public String resetPassword(String mattermostId) {
        Trainee trainee = (Trainee)this.traineeRepository.findByMattermostId(mattermostId).orElseThrow(() -> new ResponseStatusException(HttpStatus.BAD_REQUEST, "not found trainee by mattermost id."));
        String password = this.randomStringGenerator.generate();
        logger.info(mattermostId + " : " + password);
        String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
        trainee.setPassword(encodedPassword);
        this.traineeRepository.save((Object)trainee);
        return password;
    }

    @Transactional
    public void updatePassword(String id, String currentPassword, String newPassword) {
        Trainee trainee = (Trainee)this.traineeRepository.findById((Object)id).orElseThrow(() -> new ResponseStatusException(HttpStatus.BAD_REQUEST, "not found trainee by id."));
        if (!this.passwordEncoder.matches((CharSequence)currentPassword, trainee.getPassword())) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "invalid current password.");
        }
        if (!PasswordValidator.validate((String)newPassword)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "invalid new password.");
        }
        String encodedPassword = this.passwordEncoder.encode((CharSequence)newPassword);
        trainee.setPassword(encodedPassword);
        this.traineeRepository.save((Object)trainee);
    }
}

