/*
 * Decompiled with CFR 0.152.
 */
package com.lucent_global.config;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.lucent_global.repository.lucent"}, entityManagerFactoryRef="lucentEntityManagerFactory", transactionManagerRef="lucentTransactionManager")
@EntityScan(basePackages={"com.lucent_global.model.lucent"})
public class LucentDataSourceConfig {
    @Bean(name={"lucentDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.lucent")
    public DataSource lucentDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"lucentEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean lucentEntityManagerFactory(@Qualifier(value="lucentDataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(dataSource);
        em.setPackagesToScan(new String[]{"com.lucent_global.model.lucent"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        return em;
    }

    @Bean(name={"lucentTransactionManager"})
    public PlatformTransactionManager lucentTransactionManager(@Qualifier(value="lucentEntityManagerFactory") EntityManagerFactory lucentEntityManagerFactory) {
        return new JpaTransactionManager(lucentEntityManagerFactory);
    }
}

